% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class104-epoched_time-frequency.R
\name{RAVESubjectEpochTimeFreqBaseRepository}
\alias{RAVESubjectEpochTimeFreqBaseRepository}
\title{'RAVE' class for epoch repository - time-frequency (internal)}
\description{
The repository inherits \code{link{RAVESubjectEpochRepository}}, with epoch
trials, and is intended for loading processed and referenced time-frequency
coefficients.
}
\section{Super classes}{
\code{\link[ravepipeline:RAVESerializable]{ravepipeline::RAVESerializable}} -> \code{ravecore::RAVESubjectRepository} -> \code{\link[ravecore:RAVESubjectEpochRepository]{ravecore::RAVESubjectEpochRepository}} -> \code{RAVESubjectEpochTimeFreqBaseRepository}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{sample_rate}}{time-frequency coefficient sample rate}

\item{\code{frequency}}{frequencies where the time-frequency coefficients
are evaluated}

\item{\code{time}}{time in seconds for each trial}

\item{\code{time_points}}{see \code{time} field, existed for backward
compatibility}

\item{\code{signal_type}}{do not use}

\item{\code{digest_key}}{a list of repository data used to generate
repository signature}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RAVESubjectEpochTimeFreqBaseRepository-@marshal}{\code{RAVESubjectEpochTimeFreqBaseRepository$@marshal()}}
\item \href{#method-RAVESubjectEpochTimeFreqBaseRepository-@unmarshal}{\code{RAVESubjectEpochTimeFreqBaseRepository$@unmarshal()}}
\item \href{#method-RAVESubjectEpochTimeFreqBaseRepository-new}{\code{RAVESubjectEpochTimeFreqBaseRepository$new()}}
\item \href{#method-RAVESubjectEpochTimeFreqBaseRepository-mount_data}{\code{RAVESubjectEpochTimeFreqBaseRepository$mount_data()}}
\item \href{#method-RAVESubjectEpochTimeFreqBaseRepository-clone}{\code{RAVESubjectEpochTimeFreqBaseRepository$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="ravepipeline" data-topic="RAVESerializable" data-id="@compare"><a href='../../ravepipeline/html/RAVESerializable.html#method-RAVESerializable-@compare'><code>ravepipeline::RAVESerializable$@compare()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectRepository" data-id="@get_container"><a href='../../ravecore/html/RAVESubjectRepository.html#method-RAVESubjectRepository-@get_container'><code>ravecore::RAVESubjectRepository$@get_container()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectEpochRepository" data-id="export_matlab"><a href='../../ravecore/html/RAVESubjectEpochRepository.html#method-RAVESubjectEpochRepository-export_matlab'><code>ravecore::RAVESubjectEpochRepository$export_matlab()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectEpochRepository" data-id="get_container"><a href='../../ravecore/html/RAVESubjectEpochRepository.html#method-RAVESubjectEpochRepository-get_container'><code>ravecore::RAVESubjectEpochRepository$get_container()</code></a></span></li>
<li><span class="pkg-link" data-pkg="ravecore" data-topic="RAVESubjectEpochRepository" data-id="set_epoch"><a href='../../ravecore/html/RAVESubjectEpochRepository.html#method-RAVESubjectEpochRepository-set_epoch'><code>ravecore::RAVESubjectEpochRepository$set_epoch()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochTimeFreqBaseRepository-@marshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochTimeFreqBaseRepository-@marshal}{}}}
\subsection{Method \code{@marshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochTimeFreqBaseRepository$@marshal(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochTimeFreqBaseRepository-@unmarshal"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochTimeFreqBaseRepository-@unmarshal}{}}}
\subsection{Method \code{@unmarshal()}}{
Internal method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochTimeFreqBaseRepository$@unmarshal(object, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{object, ...}}{internal arguments}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochTimeFreqBaseRepository-new"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochTimeFreqBaseRepository-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochTimeFreqBaseRepository$new(
  subject,
  electrodes = NULL,
  reference_name = NULL,
  epoch_name = NULL,
  time_windows = NULL,
  stitch_events = NULL,
  data_type = NULL,
  ...,
  quiet = FALSE,
  repository_id = NULL,
  strict = TRUE,
  lazy_load = FALSE,
  .class = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{subject}}{'RAVE' subject}

\item{\code{electrodes}}{string or integers indicating electrodes to load}

\item{\code{reference_name}}{name of the reference table}

\item{\code{epoch_name}}{name of the epoch trial table}

\item{\code{time_windows}}{numeric vector with even lengths, the time start
and end of the trials, for example, \code{c(-1, 2)} means load
1 second before the trial onset and 2 seconds after trial onset}

\item{\code{stitch_events}}{events where the \code{time_windows} is based;
default is trial onset (\code{NULL})}

\item{\code{data_type}}{for child classes to fill; data type (power,
phase, or complex time-frequency coefficients)}

\item{\code{...}}{passed to \code{\link{RAVESubjectEpochRepository}} constructor}

\item{\code{quiet}}{see field \code{quiet}}

\item{\code{repository_id}}{see field \code{repository_id}}

\item{\code{strict}}{whether the mode should be strict; default is true and
errors out when subject is missing}

\item{\code{lazy_load}}{whether to delay \code{mount_data};
default is false}

\item{\code{.class}}{internally used, do not set, even if you know what this is}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochTimeFreqBaseRepository-mount_data"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochTimeFreqBaseRepository-mount_data}{}}}
\subsection{Method \code{mount_data()}}{
function to mount processed and referenced spectrogram
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochTimeFreqBaseRepository$mount_data(
  ...,
  force = TRUE,
  electrodes = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{reserved}

\item{\code{force}}{force update data; default is true}

\item{\code{electrodes}}{electrodes to update for expert-use use; default is
\code{NULL} (all electrode channels will be mounted)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RAVESubjectEpochTimeFreqBaseRepository-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RAVESubjectEpochTimeFreqBaseRepository-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RAVESubjectEpochTimeFreqBaseRepository$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
