% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getdata_bc.R
\name{getdata_bc}
\alias{getdata_bc}
\title{Download data from the rasterbc collection}
\usage{
getdata_bc(
  geo = NULL,
  collection = NULL,
  varname = NULL,
  year = NULL,
  force.dl = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{geo}{vector of character strings (NTS/SNRC codes) or a geometry of class \code{sfc}}

\item{collection}{character string indicating the data collection to query}

\item{varname}{character string indicating the layer to query}

\item{year}{integer indicating the year to query (if applicable)}

\item{force.dl}{logical indicating whether to overwrite any existing data}

\item{quiet}{logical, suppresses console messages}
}
\value{
a vector of character string(s) containing the absolute path(s) to the downloaded file(s)
}
\description{
Downloads all mapsheet layers (geoTIFFs) covering the geographical extent of \code{geo} for the
specified \code{collection}, \code{varname}, and \code{year}. Input \code{geo} can be a vector
of (4-character) NTS/SNRC mapsheet codes or a geometry of class \code{sfc}.
}
\details{
The data files are written to the directory returned by \code{rasterbc::datadir_bc()}. Mapsheets
found there (already downloaded) are not downloaded again unless \code{force.dl==TRUE}. Users
should only need to download a mapsheet once - there are no plans to update the rasterbc
collection in the future.
}
\examples{
# define a location of interest, and a polygon around it then fetch the corresponding DEM data
input.point = sf::st_point(c(x=-120.1, y=50.1)) |> sf::st_sfc(crs='EPSG:4326')

if( requireNamespace('units', quietly = TRUE) ) {
input.polygon = input.point |> sf::st_buffer(units::set_units(10, km))

\dontrun{
# the following downloads data from FRDR
block.path = getdata_bc(input.point, 'dem')
getdata_bc(input.polygon, 'dem')

# load one of the mapsheets
terra::rast(block.path)
}
}
}
\seealso{
\code{\link{findblocks_bc}} to identify which mapsheets will be downloaded

\code{\link{listdata_bc}} for a list of available collections, variable names, years
}
