% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rapiclient.R
\docType{package}
\name{rapiclient-package}
\alias{rapiclient-package}
\alias{rapiclient}
\title{rapiclient: Open API (Swagger) Client}
\description{
Create R functions directly from
OpenAPI (formerly Swagger) specification.
}
\section{Creating a client}{


  Use \code{\link{get_api}} to read the specification,
  \code{\link{get_operations}} to get client functions and
  \code{\link{get_schemas}} to create functions for additional schemas.

  See usage example at \url{https://github.com/bergant/rapiclient#rapiclient}

  Check out \url{https://github.com/OAI/OpenAPI-Specification} for additional
  information about Open API specification
}

\section{Support}{


  Please use \url{https://github.com/bergant/rapiclient/issues} for issues
}

\examples{
\dontrun{
# Read API description
api <- get_api(api_url)

# create operation and schema functions
operations <- get_operations(api)
schemas <- get_schemas(api)

# call service
operations$some_operation(x, y, schemas$some_structure(u, v, ...))
}

}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/bergant/rapiclient}
  \item Report bugs at \url{https://github.com/bergant/rapiclient/issues}
}

}
\author{
\strong{Maintainer}: Marcel Ramos \email{marcel.ramos@sph.cuny.edu} (\href{https://orcid.org/0000-0002-3242-0582}{ORCID}) [contributor]

Authors:
\itemize{
  \item Darko Bergant \email{darko.bergant@gmail.com}
}

Other contributors:
\itemize{
  \item Alexandru Mahmoud [contributor]
  \item Sean Davis [contributor]
  \item Martin Morgan [contributor]
}

}
