% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{rmmCheckValue}
\alias{rmmCheckValue}
\title{Check values of a range model metadata list against commonly used values}
\usage{
rmmCheckValue(rmm, cutoff_distance = 3, returnData = F)
}
\arguments{
\item{rmm}{a range model metadata list}

\item{cutoff_distance}{The maximum allowable similarity (Levenshtein (edit) distance) for use in fuzzy matching.}

\item{returnData}{Should a dataframe containing information on matched and unmatched values be returned?  Default is FALSE}
}
\value{
Text describing identical, similar and non-matched values for rmm entities with suggested values.  If returnData = T, a dataframe is returned containing 5 columns: field (the rmm entity), exact_match (values that appear correct), partial_match (values that are partial_match to common values), not_matched( values that are dissimilar from accepted values), partial_match_suggestions (suggested values for partial_match values).
}
\description{
Identify nonstandard values
}
\details{
See Examples.
}
\note{
Names returned by this check may be either incorrectly named or correctly named but missing from the data dictionary.
}
\examples{
rmm <- rmmTemplate() #First, we create an empty rmm template
rmm$data$environment$variableNames <- c("bio1", "bio 2", "bio3", "cromulent")
#We add 3 of the bioclim layers, including a spelling error (an extra space) in bio2,
# and a word that is clearly not a climate layer, 'cromulent'.
rmmCheckValue(rmm = rmm)
#Now, when we check the values, we see that bio1 and bio2 are reported as exact matches,
#while 'bio 2' is flagged as a partial match with a suggested value of 'bio2',
# and cromulent is flagged as not matched at all.
#If we'd like to return a dataframe containing this information in a perhaps more useful format:
rmmCheckValue_output <- rmmCheckValue(rmm = rmm, returnData = TRUE)

}
\seealso{
Other check: 
\code{\link{rmmCheckEmpty}()},
\code{\link{rmmCheckFinalize}()},
\code{\link{rmmCheckMissingNames}()},
\code{\link{rmmCheckName}()},
\code{\link{rmmCleanNULLs}()}
}
\author{
Cory Merow <cory.merow@gmail.com>, Brian Maitner <bmaitner@gmail.com>,
}
\concept{check}
