% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imbalance_test_plot.R
\name{imbalance_test_plot}
\alias{imbalance_test_plot}
\title{Plot imbalance and simulation and test results}
\usage{
imbalance_test_plot(test, vline_col = "red", stack = TRUE)
}
\arguments{
\item{test}{\code{imbalance_test} object}

\item{vline_col}{colour for the vertical line indicating the observed imbalance}

\item{stack}{logical, whether to use \code{patchwork::wrap_plots} to stack the
plots in one column (\code{TRUE}) or return a list of ggplot objects (\code{FALSE})}
}
\value{
list of ggplots or a patchwork off ggplots (if \code{stack = TRUE})
}
\description{
Plot histograms of imbalance values from simulated random allocation and a vertical
lines to indicate the observed imbalance for each randomisation level (overall,
stratification variable level, and strata level, where appropriate). The
p-values from the tests are included in the figure captions.
}
\examples{
# example code
data(rando_balance)
# without stratification variables
imb <- imbalance_test(rando_balance, "rando_res2", stratavars = c("strat1", "strat2"), n_iter = 50)
imbalance_test_plot(imb)

}
\seealso{
\code{\link[=imbalance_test]{imbalance_test()}}
}
