% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/built_in_distributions.R
\name{r_weibull}
\alias{r_weibull}
\title{Generate Weibull Distributed Values}
\usage{
r_weibull(
  shape,
  scale = 1,
  ...,
  b_scale = NULL,
  B_scale = NULL,
  n = default_n(shape, scale, b_scale, B_scale),
  .seed = NULL
)
}
\arguments{
\item{shape}{vector of shape parameters, strictly positive}

\item{scale}{vector of scale parameters, strictly positive}

\item{...}{Unused}

\item{b_scale, B_scale}{alternative definition of scale parameter, cannot be provided with
\code{scale}, strictly positive.}

\item{n}{number of observations to generate. The \code{\link[=default_n]{default_n()}} function will
provide a default value within context}

\item{.seed}{One of the following:
\itemize{
\item NULL (default) will not change the current seed. This is the
usual case for generating random numbers.
\item A numeric value. This will be used to set the seed before generating
the random numbers. This seed will be stored with the results.
\item TRUE. A random seed value will be generated and set as the seed
before the results are generated. Again, this will be stored with
the results.
}

To extract the random seed from a previously generated set of
values, use \code{pull_seed()}}
}
\value{
A numeric vector of length \code{n}
}
\description{
Generates a set of Weibull distributed values.
}
\details{
This function provides alternative definitions for the \code{scale}
parameter depending on the user's parametrisation of the Weibull
distribution, with \eqn{k} = \code{shape}.

Using \eqn{\lambda} = \code{scale}:
\deqn{
F(x) = 1 - exp(-(x/\lambda)^k)
}

Using \eqn{b} = \code{b_scale}:
\deqn{
F(x) = 1 - exp(-bx^k)
}

Using \eqn{\beta} = \code{B_scale}:
\deqn{
F(x) = 1 - exp(-(\beta x)^k)
}
}
\examples{

set_n(5)

r_weibull(10)

r_weibull(1:10, 2)

r_weibull(1:10, scale = 2)
r_weibull(1:10, b_scale = 2)
r_weibull(1:10, B_scale = 2)

r_weibull(10, 2, n = 10)
}
