% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/built_in_distributions.R
\name{r_gamma}
\alias{r_gamma}
\title{Generate Gamma Distributed Values}
\usage{
r_gamma(
  shape,
  ...,
  scale = 1,
  rate = NULL,
  mean = NULL,
  n = default_n(shape, scale, rate, mean),
  .seed = NULL
)
}
\arguments{
\item{shape}{vector of shape parameters, strictly positive}

\item{...}{Unused}

\item{scale}{vector of scale parameters, cannot be specified with \code{rate} and \code{mean},
strictly positive}

\item{rate}{vector of rate parameters, cannot be specified with \code{scale} and \code{mean},
strictly positive}

\item{mean}{vector of mean parameters, cannot be specified with \code{scale} and \code{rate},
strictly positive}

\item{n}{number of observations to generate. The \code{\link[=default_n]{default_n()}} function will
provide a default value within context}

\item{.seed}{One of the following:
\itemize{
\item NULL (default) will not change the current seed. This is the
usual case for generating random numbers.
\item A numeric value. This will be used to set the seed before generating
the random numbers. This seed will be stored with the results.
\item TRUE. A random seed value will be generated and set as the seed
before the results are generated. Again, this will be stored with
the results.
}

To extract the random seed from a previously generated set of
values, use \code{pull_seed()}}
}
\value{
A numeric vector of length \code{n}
}
\description{
Generates a set of Gamma distributed values. Can be defined by
one and only one of \code{scale}, \code{rate} or \code{mean.}
This \emph{must} be named in the call.
}
\examples{

set_n(5)

r_gamma(10)

r_gamma(1:10, scale = 2)
r_gamma(1:10, rate = 1 / 2)
r_gamma(1:10, mean = 5)

r_gamma(10, n = 10)
}
