% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randcorr.R
\name{randcorr.sample.sink}
\alias{randcorr.sample.sink}
\title{Sample from the (unnormalized) distribution sin(x)^k, 0 < x < pi, k >= 1}
\usage{
randcorr.sample.sink(k)
}
\arguments{
\item{k}{The \code{k} parameter of the distribution. If this is a vector, the function draws a random variate for every entry in \code{k}.}
}
\value{
A vector of samples with length equal to the length of \code{k}
}
\description{
Sample from the (unnormalized) distribution sin(x)^k, 0 < x < pi, k >= 1
}
\section{Details}{

This code generates samples from the sin(x)^k distribution using the specified vector \code{k}.
}

\examples{
# -----------------------------------------------------------------
# Example 1: Draw a random variate from sin(x), 0<x<pi
x = randcorr.sample.sink(1)

# Example 2: Draw a million random variate from sin^3(x), 0<x<pi
x = randcorr.sample.sink( matrix(3, 1e6,1) )
mean(x)
var(x)


}
\references{
Enes Makalic and Daniel F. Schmidt
 An efficient algorithm for sampling from sin^k(x) for generating random correlation matrices,
 arXiv:1809.05212, 2018.
}
\seealso{
\code{\link{randcorr}}
}
