% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randcorr.R
\name{randcorr}
\alias{randcorr}
\title{Generate a random p x p correlation matrix}
\usage{
randcorr(p)
}
\arguments{
\item{p}{A scalar positive integer denoting the size of the correlation matrix}
}
\value{
A random p x p correlation matrix
}
\description{
Generate a random p x p correlation matrix
}
\note{
To cite this package please reference: 

Makalic, E. & Schmidt, D. F.
An efficient algorithm for sampling from sin^k(x) for generating random correlation matrices
arXiv:1809.05212, 2018 \url{https://arxiv.org/abs/1809.05212}

A MATLAB-compatible implementation of the sampler in this package can be obtained from:

\url{https://au.mathworks.com/matlabcentral/fileexchange/68810-randcorr}
}
\section{Details}{

This function implements the algorithm by Pourahmadi and Wang [1] for generating a random p x p correlation matrix. 
Briefly, the idea is to represent the correlation matrix using Cholesky factorization and p(p-1)/2 hyperspherical coordinates
(i.e., angles), sample the angles form a particular distribution and then convert to the standard correlation matrix form. The  
angles are sampled from a distribution with probability density function sin^k(theta) (0 < theta < pi, k >= 1) using the efficient
sampling algorithm described in [2].
}

\examples{
# -----------------------------------------------------------------
# Example 1: Generate a 5x5 correlation matrix
C = randcorr(5)

# Example 2: Generate a 1000x1000 correlation matrix
C = randcorr(1000)



}
\references{
[1] Mohsen Pourahmadi and Xiao Wang,
 Distribution of random correlation matrices: Hyperspherical parameterization of the Cholesky factor,
 Statistics & Probability Letters, Volume 106, Pages 5-12, 2015.
 
 [2] Enes Makalic and Daniel F. Schmidt
 An efficient algorithm for sampling from sin^k(x) for generating random correlation matrices,
 arXiv:1809.05212, 2018.
}
\seealso{
\code{\link{randcorr.sample.sink}}
}
