% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_records.R
\name{update_records}
\alias{update_records}
\title{Update Airtable records}
\usage{
update_records(
  data,
  airtable,
  columns = dplyr::everything(),
  airtable_id_col = "airtable_record_id",
  safely = TRUE,
  parallel = FALSE,
  batch_size = 10
)
}
\arguments{
\item{data}{A dataframe containing the records and fields to update}

\item{airtable}{An airtable object}

\item{columns}{Columns in the data to update on Airtable. Can be a vector of character strings, unquoted column names, or a \code{dplyr} tidyselect helper like \code{starts_with()}, \code{ends_with()} or \code{everything()}. Defaults to \code{dplyr::everything()}}

\item{airtable_id_col}{Column containing Airtable record IDs. Not required if record IDs are stored in row names as returned from \code{read_airtable}}

\item{safely}{If \code{TRUE}, confirm number and names of columns to update and number of rows before executing update.}

\item{parallel}{If \code{TRUE} use parallel processing for encoding large tables}

\item{batch_size}{Number of records to update per request. Maximum of 10}
}
\value{
A dataframe (invisibly) of the input data, to be stored as an object or piped into further `dplyr` functions
}
\description{
Update one or more columns of data in an Airtable table. Supports batch updates and parallel JSON encoding (recommended for large tables).
}
