% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_package.R
\name{make_package}
\alias{make_package}
\title{Make an Analysis Project}
\usage{
make_package(
  path,
  type = c("Quarto (analysis.qmd)", "R Markdown (analysis.Rmd)"),
  example = FALSE,
  overwrite = FALSE,
  openInteractive = TRUE
)
}
\arguments{
\item{path}{Path automatically set by research_project.dcf (see
\code{./rstudio/templates/project/})}

\item{type}{Choose between "Quarto (analysis.qmd)" or
"R Markdown (analysis.Rmd)"}

\item{example}{Will the analysis file include an example table/figure?}

\item{overwrite}{Will an existing RStudio project be overwritten?  This is
needed for for Posit.Cloud.  You will be prompted to confirm this option.}

\item{openInteractive}{Should this new project be opened in a new RStudio
window? Defaults to \code{TRUE}. NOTE: this option exists to prevent
RStudio from opening two duplicate versions of the new project when
this function is executed from RStudio menus. MODIFY WITH CAUTION.}
}
\value{
Returns nothing.  See description above.
}
\description{
This function creates the structure for an R package. An analysis.Qmd (or
analysis.Rmd) is created in the vignettes directory. This
project includes an aggressive .gitignore which is designed to
help protect against leaking data (with protected  health information), a
starter bibliography file called "references" (in standard .bib format),
and a stock Citation Style Language (.csl) file for the New England Journal
of Medicine.
}
\details{
Behind the scenes, this function used by research_project.dcf when
a user selects New project... > New Directory > rUM Research Project Template
within the RStudio IDE. See \code{./rstudio/templates/project/}.
}
\note{
If you need to create multiple packages from the same session, restart
RStudio/Positron after making each one. See \href{https://github.com/RaymondBalise/rUM/issues/84}{open issue}.
}
\examples{
\dontrun{
  # This makes a package with an example Quarto paper in the vignettes folder.
  make_package(path = "~/test", type = "Quarto (analysis.qmd)", example = TRUE)
  
  # make_package() allows abbreviations on the project type: "Q" for Quarto or "R" for R Markdown
  make_package(path = "~/test_project", "Q", TRUE)
  
  # This makes a package with an example R Markdown paper in the vignettes folder.
  make_package(path = "~/test", type = "R Markdown (analysis.Rmd)", example = TRUE)
              
  # This makes a project with an example paper in the vignettes folder.
  make_package(path = "~/test_project", "R", example = TRUE)
}
}
