% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_params.R
\name{calc_params}
\alias{calc_params}
\title{Calculate extra parameters of a thermal performance curve}
\usage{
calc_params(model)
}
\arguments{
\item{model}{nls model object that contains a model of a thermal performance curve}
}
\value{
a dataframe containing the estimates of key TPC traits for a given model object. If any parameters cannot be calculated for a thermal performance curve, they will return \code{NA}.
}
\description{
Calculate extra parameters of a thermal performance curve
}
\details{
Currently estimates:
\itemize{
\item maximum rate (rmax) using \code{\link[=get_rmax]{get_rmax()}}
\item optimum temperature (topt) using \code{\link[=get_topt]{get_topt()}}
\item critical thermal maximum (ctmax) using \code{\link[=get_ctmax]{get_ctmax()}}
\item critical thermal minimum (ctmin) using \code{\link[=get_ctmin]{get_ctmin()}}
\item activation energy (e) using \code{\link[=get_e]{get_e()}}
\item deactivation energy (eh) using \code{\link[=get_eh]{get_eh()}}
\item q10 value using \code{\link[=get_q10]{get_q10()}}
\item thermal safety margin using \code{\link[=get_thermalsafetymargin]{get_thermalsafetymargin()}}
\item thermal tolerance using \code{\link[=get_thermaltolerance]{get_thermaltolerance()}}
\item thermal performance breadth using \code{\link[=get_breadth]{get_breadth()}}
\item skewness using \code{\link[=get_skewness]{get_skewness()}}
}
}
