% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tlsrotate3d.R
\name{tlsrotate3d}
\alias{tlsrotate3d}
\title{Rotate TLS-derived 3D Point Clouds}
\usage{
tlsrotate3d(las, theta, by = "z", scale = TRUE)
}
\arguments{
\item{las}{An object of class LAS [lidR::readLAS()].}

\item{theta}{Numeric defining the angle in degrees (from 0 to 360) for rotating the 3d point cloud.}

\item{by}{Character defining the rotation around x ('x'), y ('y') or z ('z') axis. Default: around z-axis.}

\item{scale}{if TRUE, the xyz coordinates will be scaled to local coordinates by subtracting their values to their
corresponding minimum values (e.g. x - min(x). Default is TRUE.}
}
\value{
Returns an object of class LAS containing the rotated 3d point cloud.
}
\description{
This function rotates TLS-derived 3D Point Clouds
}
\examples{
\donttest{
# Path to las file
lasfile <- system.file("extdata", "tree_c1.laz", package="rTLsDeep")

# Reading las file
las<-lidR::readLAS(lasfile)

# Visualizing las file
suppressWarnings(lidR::plot(las))

# Rotating 3d point cloud around Z-axis
lasr<-tlsrotate3d(las,theta=180, by="x", scale=TRUE)

# Visualizing rotated las file
suppressWarnings(lidR::plot(lasr))

if (!rgl::rgl.useNULL())
 rgl::play3d(rgl::spin3d(axis = c(0, 0, 1), rpm = 5), duration = 10)

}
}
