% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPublic.R
\name{rp_getQuote}
\alias{rp_getQuote}
\title{Get Trading Quotes}
\usage{
rp_getQuote(accountId, ticker, type)
}
\arguments{
\item{accountId}{= Public Brokerage Account Number}

\item{ticker}{= Ticker symbol: Ex. "SPY"}

\item{type}{= Ticker Type: Ex. 'EQUITY','OPTION','MULTI_LEG_INSTRUMENT', 'CRYPTO', 'ALT','TREASURY', 'BOND', 'INDEX'}
}
\value{
Retrieve real-time quotes as a \code{data.frame}.
}
\description{
Get Trading Quotes
}
\examples{
\dontrun{
 # Fetches Multiple Real-Time Quotes
 my_acc <- rp_getAccts()
 rp_getQuote(accountId = my_acc$accountId, ticker = "TSLA", type="EQUITY")
 rp_getQuote(accountId = my_acc$accountId, ticker = 'SPY250807C00633000', type = "OPTION") 
 rp_getQuote(accountId = my_acc$accountId, 
             ticker = c("AAPL", 'SPY250807C00633000'), 
             type = c("EQUITY", "OPTION"))
}
}
