% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{values_minimize}
\alias{values_minimize}
\title{Simplify a Kolada values table}
\usage{
values_minimize(values_df)
}
\arguments{
\item{values_df}{A Kolada value table, as created by
\code{\link{get_values}}.}
}
\value{
A Kolada values table
}
\description{
Simplify a Kolada values table, i.e as created by \code{\link{get_values}},
by removing columns that contain monotonous data, i.e. that contain only one
value for all observations.
}
\examples{
# Download values for all available years of a given KPI for
# Malmö municipality (code 1280)
if (kolada_available()) {
vals <- get_values(kpi = "N45933", municipality = "1280", simplify = TRUE)
# (Returns a table with 5 rows and 8 columns)

# Remove columns with no information to differentiate between rows
values_minimize(vals)
# (Returns a table with 5 rows and 4 columns)
}
}
