% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpi_groups.R
\name{kpi_grp_unnest}
\alias{kpi_grp_unnest}
\title{Create a KPI table from a Kolada KPI Group metadata table}
\usage{
kpi_grp_unnest(kpi_grp_df)
}
\arguments{
\item{kpi_grp_df}{A Kolada KPI Group metadata table, as created by e.g.
\code{get_kpi_groups}.}
}
\value{
A Kolada KPI metadata table
}
\description{
KPI groups are a convenient way to discover sets of KPIs that can be used to
highlight different aspects of a policy area. A practical workflow for
discovering such sets can be to search through KPI Group metadata using
\code{\link{kpi_grp_search}} to search for keywords and
\code{\link{kpi_grp_describe}} to inspect contents of KPI groups. Once you
have created a KPI group table that has been narrowed down to the group/s you
are looking for, \code{\link{kpi_grp_unnest}} is used to create a KPI
metadata table for further processing.
}
\examples{
if (kolada_available()) {
# Download KPI Group metadata
kpi_grp_df <- get_kpi_groups()

# Create a KPI metadata table from KPI groups matching the term
# "utbidning" (education)
kpi_grp_df \%>\%
  kpi_grp_search("utbildning") \%>\%
  kpi_grp_unnest()
}

}
