% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rIACI.R
\name{cdd_std}
\alias{cdd_std}
\title{Calculate Standardized CDD Index}
\usage{
cdd_std(ci, freq = c("monthly", "seasonal"))
}
\arguments{
\item{ci}{List. Climate input object.}

\item{freq}{Character. Frequency of calculation, either "monthly" or "seasonal".}
}
\value{
Data frame with dates and standardized CDD values.
}
\description{
Calculates the standardized consecutive dry days index.
}
\examples{
\donttest{
# 1. Generate a daily date sequence from 1960-01-01 to 2020-12-31
dates <- seq.Date(
  from = as.Date("1960-01-01"),
  to   = as.Date("2020-12-31"),
  by   = "day"
)

# 2. Create random weather data for each date
n <- length(dates)
tmax <- runif(n, min = 5, max = 40)
tmin <- runif(n, min = -10,  max = 5)
# Example: use a Poisson distribution to simulate precipitation
prec <- rpois(n, lambda = 2)
# Random wind speeds, e.g., 0 to 10 m/s
wind <- runif(n, min = 0, max = 10)

# 3. Construct the climate_input object
ci <- climate_input(
  tmax  = tmax,
  tmin  = tmin,
  prec  = prec,
  wind  = wind,
  dates = dates
)
# Then:
# 4. Calculate standardized CDD index on a monthly basis
cdd_std_values <- cdd_std(ci, freq = "monthly")
}
}
