% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piped.R
\name{project}
\alias{project}
\title{Project ENA Points onto Rotated Space}
\usage{
project(x, rotation = NULL, add.meta = TRUE)
}
\arguments{
\item{x}{An \code{ena.set} object containing the points for projection and rotation matrix.}

\item{rotation}{Optional. A rotation matrix to use for projection if \code{x} is not an \code{ena.set}.}

\item{add.meta}{Logical. If \code{TRUE} (default), metadata will be included in the output.}
}
\value{
The input \code{ena.set} object with the projected points matrix (and metadata if requested).
}
\description{
This function projects ENA points onto the rotated space using the rotation matrix.
Optionally, metadata can be included in the resulting points matrix.
}
\examples{
# Assuming 'set' is an ena.set object:
data(RS.data)

codes <- c("Data", "Technical.Constraints", "Performance.Parameters",
           "Client.and.Consultant.Requests", "Design.Reasoning",
           "Collaboration")
units <- c("Condition", "UserName")
horizon <- c("Condition", "GroupName")
enaset <- RS.data |>
  accumulate(units, codes, horizon) |>
  sphere_norm() |>
  center() |>
  rotate() |>
  project()
}
