% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new_code_run.R
\name{new_code_run}
\alias{new_code_run}
\title{Post entry to code_run table}
\usage{
new_code_run(
  run_date,
  description,
  code_repo_url,
  model_config_url,
  submission_script_url,
  inputs_urls = list(),
  outputs_urls = list(),
  endpoint = "http://127.0.0.1:8000/api/"
)
}
\arguments{
\item{run_date}{the date-time of the \code{code_run}
\emph{e.g.} \code{Sys.time()} or "2010-07-11 12:15:00 BST"}

\item{description}{(optional) a \code{string} containing a free text
description of the \code{code_run}}

\item{code_repo_url}{(optional) a \code{string} specifying the URL of an
\code{object} associated with the \code{code_repo_release} that was run}

\item{model_config_url}{(optional) a \code{string} specifying the URL of an
\code{object} associated with the working config file used for the
\code{code_run}}

\item{submission_script_url}{(optional) a \code{string} specifying the URL
of an \code{object} associated with the submission script used for the
\code{code_run}}

\item{inputs_urls}{a \code{list} of \code{object_component} URLs referencing
\code{code_run} inputs}

\item{outputs_urls}{a \code{list} of \code{object_component} URLs referencing
\code{code_run} outputs}

\item{endpoint}{a \code{string} specifying the registry endpoint}
}
\description{
Upload information to the \code{code_run} table in the data registry
}
\seealso{
Other new functions: 
\code{\link{new_author}()},
\code{\link{new_code_repo_release}()},
\code{\link{new_data_product}()},
\code{\link{new_external_object}()},
\code{\link{new_file_type}()},
\code{\link{new_issue}()},
\code{\link{new_keyword}()},
\code{\link{new_licence}()},
\code{\link{new_namespace}()},
\code{\link{new_object}()},
\code{\link{new_object_component}()},
\code{\link{new_quality_controlled}()},
\code{\link{new_storage_location}()},
\code{\link{new_storage_root}()},
\code{\link{new_user_author}()}
}
\concept{new functions}
\keyword{internal}
