% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{on_start}
\alias{on_start}
\title{on_start helper function}
\usage{
on_start(plotdir, csvdir, logfilename, parallel)
}
\arguments{
\item{plotdir}{A character string. Path to the folder,
where plots are saved.}

\item{csvdir}{A character string. Path to the folder,
where resulting tables are saved.}

\item{logfilename}{A character string. Path to a file to save the log
messages (default = paste0(tempdir(), "/log.txt")).}

\item{parallel}{A boolean. If TRUE (the default value), initializing
\code{future::plan("multicore")} (on unix systems) or
\code{future::plan("multisession")} (on non-unix systems) before running the
code.}
}
\value{
This function silently creates the directories\code{plotdir} and \code{csvdir}
on the local filesystem and initializes the logfile, specified with
\code{logfilename}. Furthermore, if \code{parallel = TRUE}, the \code{future}-backend is
initialized.
}
\description{
Internal function, that initializes plotdir,
csvdir and logfilename.
}
\examples{
\donttest{ # runtime > 5 sec.
plotdir <- paste0(tempdir(), "/plots/")
csvdir <- paste0(tempdir(), "/csv/")
logfilename <- paste0(tempdir(), "/log.txt")
parallel <- FALSE

on_start(plotdir, csvdir, logfilename, parallel)
}

}
\seealso{
\link[future]{plan}
}
