% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6.2_Plackett_Burman_designs_Classes.R
\name{pbDesign.c}
\alias{pbDesign.c}
\title{pbDesign}
\description{
An R6 class representing a Plackett-Burman design.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{A character string specifying the name of the design. Default is \code{NULL}.}

\item{\code{factors}}{A list of factors included in the Taguchi design. Each factor is typically an instance of the \code{pbFactor} class.}

\item{\code{design}}{A \code{data.frame} representing the design matrix of the experiment. This includes the levels of each factor for every run of the experiment. Default is an empty \code{data.frame}.}

\item{\code{designType}}{A character string specifying the type of Taguchi design used. Default is \code{NULL}.}

\item{\code{replic}}{A \code{data.frame} containing the replication information for the design. Default is an empty \code{data.frame}.}

\item{\code{response}}{A \code{data.frame} storing the response values collected from the experiment. Default is an empty \code{data.frame}.}

\item{\code{Type}}{A \code{data.frame} specifying the type of responses or factors involved in the design. Default is an empty \code{data.frame}.}

\item{\code{block}}{A \code{data.frame} indicating any blocking factors used in the design. Default is an empty \code{data.frame}.}

\item{\code{runOrder}}{A \code{data.frame} detailing the order in which the experimental runs were conducted. Default is an empty \code{data.frame}.}

\item{\code{standardOrder}}{A \code{data.frame} detailing the standard order of the experimental runs. Default is an empty \code{data.frame}.}

\item{\code{desireVal}}{A list storing desired values for responses in the experiment. Default is an empty list.}

\item{\code{desirability}}{A list storing desirability functions used to evaluate the outcomes of the experiment. Default is an empty list.}

\item{\code{fits}}{A \code{data.frame} containing model fits or other statistical summaries from the analysis of the experimental data. Default is an empty \code{data.frame}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-pbDesign.c-values}{\code{pbDesign.c$values()}}
\item \href{#method-pbDesign.c-units}{\code{pbDesign.c$units()}}
\item \href{#method-pbDesign.c-.factors}{\code{pbDesign.c$.factors()}}
\item \href{#method-pbDesign.c-names}{\code{pbDesign.c$names()}}
\item \href{#method-pbDesign.c-as.data.frame}{\code{pbDesign.c$as.data.frame()}}
\item \href{#method-pbDesign.c-print}{\code{pbDesign.c$print()}}
\item \href{#method-pbDesign.c-.response}{\code{pbDesign.c$.response()}}
\item \href{#method-pbDesign.c-.nfp}{\code{pbDesign.c$.nfp()}}
\item \href{#method-pbDesign.c-summary}{\code{pbDesign.c$summary()}}
\item \href{#method-pbDesign.c-clone}{\code{pbDesign.c$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pbDesign.c-values"></a>}}
\if{latex}{\out{\hypertarget{method-pbDesign.c-values}{}}}
\subsection{Method \code{values()}}{
Get and set the \code{values} for an object of class \code{pbDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pbDesign.c$values(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New value, If missing value get the \code{values}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pbDesign.c-units"></a>}}
\if{latex}{\out{\hypertarget{method-pbDesign.c-units}{}}}
\subsection{Method \code{units()}}{
Get and set the \code{units} for an object of class \code{pbDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pbDesign.c$units(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New units, If missing value get the \code{units}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pbDesign.c-.factors"></a>}}
\if{latex}{\out{\hypertarget{method-pbDesign.c-.factors}{}}}
\subsection{Method \code{.factors()}}{
Get and set the \code{factors} in an object of class \code{pbDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pbDesign.c$.factors(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New factors, If missing value get the \code{factors}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pbDesign.c-names"></a>}}
\if{latex}{\out{\hypertarget{method-pbDesign.c-names}{}}}
\subsection{Method \code{names()}}{
Get and set the \code{names} in an object of class \code{pbDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pbDesign.c$names(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New names, If missing value get the \code{names}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pbDesign.c-as.data.frame"></a>}}
\if{latex}{\out{\hypertarget{method-pbDesign.c-as.data.frame}{}}}
\subsection{Method \code{as.data.frame()}}{
Return a data frame with the information of the object \code{pbDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pbDesign.c$as.data.frame()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pbDesign.c-print"></a>}}
\if{latex}{\out{\hypertarget{method-pbDesign.c-print}{}}}
\subsection{Method \code{print()}}{
Methods for function \code{print} in Package \code{base}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pbDesign.c$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pbDesign.c-.response"></a>}}
\if{latex}{\out{\hypertarget{method-pbDesign.c-.response}{}}}
\subsection{Method \code{.response()}}{
Get and set the the \code{response} in an object of class \code{pbDesign}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pbDesign.c$.response(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New response, If missing value get the \code{response}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pbDesign.c-.nfp"></a>}}
\if{latex}{\out{\hypertarget{method-pbDesign.c-.nfp}{}}}
\subsection{Method \code{.nfp()}}{
Prints a summary of the factors attributes including their low, high, name, unit, and type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pbDesign.c$.nfp()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pbDesign.c-summary"></a>}}
\if{latex}{\out{\hypertarget{method-pbDesign.c-summary}{}}}
\subsection{Method \code{summary()}}{
Methods for function \code{summary} in Package \code{base}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pbDesign.c$summary()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pbDesign.c-clone"></a>}}
\if{latex}{\out{\hypertarget{method-pbDesign.c-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pbDesign.c$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
