% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1.3_Distr_DistrCollection_Functions.R
\name{paretoChart}
\alias{paretoChart}
\title{paretoChart: Pareto Chart}
\usage{
paretoChart(
  x,
  weight,
  main,
  col,
  border,
  xlab,
  ylab = "Frequency",
  percentVec,
  showTable = TRUE,
  showPlot = TRUE
)
}
\arguments{
\item{x}{A vector of qualitative values.}

\item{weight}{A numeric vector of weights corresponding to each category in \code{x}.}

\item{main}{A character string for the main title of the plot.}

\item{col}{A numerical value or character string defining the fill-color of the bars.}

\item{border}{A numerical value or character string defining the border-color of the bars.}

\item{xlab}{A character string for the x-axis label.}

\item{ylab}{A character string for the y-axis label. By default, \code{ylab} is set to \code{`Frequency`}.}

\item{percentVec}{A numerical vector giving the position and values of tick marks for percentage axis.}

\item{showTable}{Logical value indicating whether to display a table of frequencies. By default, \code{showTable} is set to \code{TRUE}.}

\item{showPlot}{Logical value indicating whether to display the Pareto chart. By default, \code{showPlot} is set to \code{TRUE}.}
}
\value{
\code{paretoChart} returns a Pareto chart along with a frequency table if \code{showTable} is \code{TRUE}.
Additionally, the function returns an invisible list containing:
\item{plot}{The generated Pareto chart.}
\item{table}{A data.frame with the frequencies and percentages of the categories.}
}
\description{
Function to create a Pareto chart, displaying the relative frequency of categories.
}
\examples{
# Example 1: Creating a Pareto chart for defect types
defects1 <- c(rep("E", 62), rep("B", 15), rep("F", 3), rep("A", 10),
              rep("C", 20), rep("D", 10))
paretoChart(defects1)

# Example 2: Creating a Pareto chart with weighted frequencies
defects2 <- c("E", "B", "F", "A", "C", "D")
frequencies <- c(62, 15, 3, 10, 20, 10)
weights <- c(1.5, 2, 0.5, 1, 1.2, 1.8)
names(weights) <- defects2  # Assign names to the weights vector

paretoChart(defects2, weight = frequencies * weights)
}
