% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_extraPlots.R
\name{mvPlot}
\alias{mvPlot}
\title{mvPlot: Function to create a multi-variable plot}
\usage{
mvPlot(
  response,
  fac1,
  fac2,
  fac3,
  fac4,
  sort = TRUE,
  col,
  pch,
  labels = FALSE,
  quantile = TRUE,
  FUN = NA
)
}
\arguments{
\item{response}{The values of the \code{response} in a vector.response must be declared.}

\item{fac1}{Vector providing factor 1 as shown in the example.\code{fac1} must be declared.}

\item{fac2}{Vector providing factor 1 as shown in the example.\code{fac2} must be declared.}

\item{fac3}{Optional vector providing factor 3 as shown in the example.}

\item{fac4}{Optional vector providing factor 4 as shown in the example.}

\item{sort}{Logical value indicating whether the sequence of the factors given by \code{fac1} - \code{fac4} should be reordered to minimize the space needed to visualize the Multi-Vari-Chart. By default \code{sort} is set to `TRUE`.}

\item{col}{Graphical parameter. Vector containing numerical values or character strings giving the colors for the different factors. By default \code{col} starts with the value `3` and is continued as needed.}

\item{pch}{Graphical parameter. Vector containing numerical values or single characters giving plotting points for the different factors. See \code{points} for possible values and their interpretation. Note that only integers and single-character strings can be set as a graphics parameter (and not \code{NA} nor \code{NULL}). By default \code{pch} starts with the value `1` and is continued as needed.}

\item{labels}{Logical value indicating whether the single points should be labels with the row-number of the \code{data.frame} invisibly returned by the function \code{mvPlot}. By default \code{labels} is set to `FALSE`.}

\item{quantile}{A logical value indicating whether the quanitiles (0.00135, 0.5 & 0.99865) should be visualized for the single groups. By default \code{quantile} is set to `TRUE`.}

\item{FUN}{An optional function to be used for calculation of \code{response} for unique settings of the factors e.g. the \code{mean}. By default \code{FUN} is set to `NA` and therfore omitted.}
}
\value{
\code{mvPlot} returns an invisible list cointaining: a data.frame in which all plotted points are listed and the final plot. The option labels can be used to plot the row-numbers at the single points and to ease the identification.
}
\description{
Creates a plot for visualizing the relationships between a response variable and multiple factors.
}
\examples{
#Example I
examp1 = expand.grid(c("Engine1","Engine2","Engine3"),c(10,20,30,40))
examp1 = as.data.frame(rbind(examp1, examp1, examp1))
examp1 = cbind(examp1, rnorm(36, 1, 0.02))
names(examp1) = c("factor1", "factor2", "response")
mvPlot(response = examp1[,3], fac1 = examp1[,2],fac2 = examp1[,1],sort=FALSE,FUN=mean)
}
