% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.3_Factorial_designs_Functions.R
\name{interactionPlot}
\alias{interactionPlot}
\title{interactionPlot}
\usage{
interactionPlot(dfac, response = NULL, fun = mean, main, col = 1:2)
}
\arguments{
\item{dfac}{An object of class \code{\link{facDesign.c}}, representing a factorial design.}

\item{response}{Response variable. If the response data frame of fdo consists of more then one responses, this variable can be used to choose just one column of the response data frame.
\code{response} Needs to be an object of class character with length of `1`. It needs to be the same character as the name of the response in the response data frame that should be plotted.}

\item{fun}{Function to use for the calculation of the interactions (e.g., \code{mean}, \code{median}). Default is \code{mean}.}

\item{main}{Character string: title of the plot.}

\item{col}{Vector of colors for the plot. Single colors can be given as character strings or numeric values. Default is \code{1:2}.}
}
\value{
Return an interaction plot for the factors in a factorial design.
}
\description{
Creates an interaction plot for the factors in a factorial design to visualize the interaction effects between them.
}
\details{
\code{interactionPlot()} displays interactions for an object of class \code{facDesign} (i.e. 2^k full or 2^k-p fractional factorial design).
Parts of the original interactionPlot were integrated.
}
\examples{
# Example 1
# Create the facDesign object
dfac <- facDesign(k = 3, centerCube = 4)
dfac$names(c('Factor 1', 'Factor 2', 'Factor 3'))

# Assign performance to the factorial design
rend <- c(simProc(120,140,1), simProc(80,140,1), simProc(120,140,2),
          simProc(120,120,1), simProc(90,130,1.5), simProc(90,130,1.5),
          simProc(80,120,2), simProc(90,130,1.5), simProc(90,130,1.5),
          simProc(120,120,2), simProc(80,140,2), simProc(80,120,1))
dfac$.response(rend)

# Create an interaction plot
interactionPlot(dfac, fun = mean, col = c("purple", "red"))

# Example 2
vp <- fracDesign(k=3, replicates = 2)
y <- 4*vp$get(j=1) -7*vp$get(j=2) + 2*vp$get(j=2)*vp$get(j=1) +
     0.2*vp$get(j=3) + rnorm(16)
vp$.response(y)

interactionPlot(vp)
}
\seealso{
\code{\link{fracDesign}}, \code{\link{facDesign}}
}
