% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2.3_gageRR_Functions.R
\name{gageRR}
\alias{gageRR}
\title{gageRR: Gage R&R - Gage Repeatability and Reproducibility}
\usage{
gageRR(
  gdo,
  method = "crossed",
  sigma = 6,
  alpha = 0.25,
  tolerance = NULL,
  dig = 3,
  print = TRUE
)
}
\arguments{
\item{gdo}{Needs to be an object of class \code{gageRR.c}.}

\item{method}{Character string specifying the Gage R&R method. \code{`crossed`} which is the typical design for performing a Measurement Systems Analysis using Gage Repeatability and Reproducibility or \code{`nested`} which is used for destructive testing (i.e. the same part cannot be measured twice). Operators measure each a different sample of parts under the premise that the parts of each batch are alike.
By default \code{method} is set to \code{`crossed`}.}

\item{sigma}{Numeric value giving the number of sigmas.
For \code{sigma=6} this relates to 99.73 percent representing the full spread of a normal distribution function (i.e. \code{pnorm(3) - pnorm(-3)}).
Another popular setting \code{sigma=5.15} relates to 99 percent (i.e. \code{pnorm(2.575) - pnorm(-2.575)}). By default \code{sigma} is set to `6`.}

\item{alpha}{Alpha value for discarding the interaction Operator:Part and fitting a non-interaction model. By default \code{alpha} is set to `0.25`.}

\item{tolerance}{Mumeric value giving the tolerance for the measured parts. This is required to calculate the Process to Tolerance Ratio.
By default \code{tolerance} is set to \code{NULL}.}

\item{dig}{numeric value giving the number of significant digits for \code{format}.
By default \code{dig} is set to `3`.}

\item{print}{Print the summary of the perform of the Gage.}
}
\value{
The function \code{gageRR} returns an object of class \code{gageRR.c} and shows typical Gage Repeatability and Reproducibility Output including Process to Tolerance Ratios and the number of distinctive categories (i.e. ndc) the measurement system is able to discriminate with the tested setting.
}
\description{
Performs a Gage R&R analysis for an object of class \code{\link{gageRR.c}}.
}
\examples{
# Create de gageRR Design
design <- gageRRDesign(Operators = 3, Parts = 10, Measurements = 3,
                       method = "crossed", sigma = 6, randomize = TRUE)
design$response(rnorm(nrow(design$X), mean = 10, sd = 2))

# Results of de Design
result <- gageRR(gdo = design, method = "crossed", sigma = 6, alpha = 0.25)
class(result)
result$plot()
}
\seealso{
\code{\link{gageRR.c}}, \code{\link{gageRRDesign}}, \code{\link{gageLin}}, \code{\link{cg}}.
}
