% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3.2_Factorial_designs_Classes.R
\name{facDesign.c}
\alias{facDesign.c}
\title{facDesign-class: Class `facDesign`}
\description{
The \code{facDesign.c} class is used to represent factorial designs, including their factors, responses, blocks, and design matrices. This class supports various experimental designs and allows for the storage and manipulation of data related to the design and analysis of factorial experiments.
}
\seealso{
\code{\link{mixDesign.c}}, \code{\link{taguchiDesign.c}}.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{Character string representing the name of the factorial design.}

\item{\code{factors}}{List of factors involved in the factorial design, including their levels and settings.}

\item{\code{cube}}{Data frame containing the design matrix for the cube portion of the factorial design.}

\item{\code{star}}{Data frame containing the design matrix for the star portion of the factorial design.}

\item{\code{centerCube}}{Data frame containing the center points within the cube portion of the factorial design.}

\item{\code{centerStar}}{Data frame containing the center points within the star portion of the factorial design.}

\item{\code{generator}}{List of generators used to create the fractional factorial design.}

\item{\code{response}}{Data frame containing the responses or outcomes measured in the design.}

\item{\code{block}}{Data frame specifying the block structures if the design is blocked.}

\item{\code{blockGen}}{Data frame specifying the block generators for the design.}

\item{\code{runOrder}}{Data frame specifying the order in which runs are performed.}

\item{\code{standardOrder}}{Data frame specifying the standard order of the runs.}

\item{\code{desireVal}}{List of desired values or targets for the response variables.}

\item{\code{desirability}}{List of desirability scores or metrics based on the desired values.}

\item{\code{fits}}{Data frame containing the fitted model parameters and diagnostics for the responses in the design.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-facDesign.c-nrow}{\code{facDesign.c$nrow()}}
\item \href{#method-facDesign.c-ncol}{\code{facDesign.c$ncol()}}
\item \href{#method-facDesign.c-print}{\code{facDesign.c$print()}}
\item \href{#method-facDesign.c-.clear}{\code{facDesign.c$.clear()}}
\item \href{#method-facDesign.c-names}{\code{facDesign.c$names()}}
\item \href{#method-facDesign.c-as.data.frame}{\code{facDesign.c$as.data.frame()}}
\item \href{#method-facDesign.c-get}{\code{facDesign.c$get()}}
\item \href{#method-facDesign.c-lows}{\code{facDesign.c$lows()}}
\item \href{#method-facDesign.c-highs}{\code{facDesign.c$highs()}}
\item \href{#method-facDesign.c-.nfp}{\code{facDesign.c$.nfp()}}
\item \href{#method-facDesign.c-identity}{\code{facDesign.c$identity()}}
\item \href{#method-facDesign.c-summary}{\code{facDesign.c$summary()}}
\item \href{#method-facDesign.c-.response}{\code{facDesign.c$.response()}}
\item \href{#method-facDesign.c-effectPlot}{\code{facDesign.c$effectPlot()}}
\item \href{#method-facDesign.c-lm}{\code{facDesign.c$lm()}}
\item \href{#method-facDesign.c-desires}{\code{facDesign.c$desires()}}
\item \href{#method-facDesign.c-set.fits}{\code{facDesign.c$set.fits()}}
\item \href{#method-facDesign.c-types}{\code{facDesign.c$types()}}
\item \href{#method-facDesign.c-unit}{\code{facDesign.c$unit()}}
\item \href{#method-facDesign.c-.star}{\code{facDesign.c$.star()}}
\item \href{#method-facDesign.c-.blockGen}{\code{facDesign.c$.blockGen()}}
\item \href{#method-facDesign.c-.block}{\code{facDesign.c$.block()}}
\item \href{#method-facDesign.c-.centerCube}{\code{facDesign.c$.centerCube()}}
\item \href{#method-facDesign.c-.centerStar}{\code{facDesign.c$.centerStar()}}
\item \href{#method-facDesign.c-.generators}{\code{facDesign.c$.generators()}}
\item \href{#method-facDesign.c-clone}{\code{facDesign.c$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-nrow"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-nrow}{}}}
\subsection{Method \code{nrow()}}{
Get the number of rows Design.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$nrow()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-ncol"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-ncol}{}}}
\subsection{Method \code{ncol()}}{
Get the number of columns Design.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$ncol()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-print"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-print}{}}}
\subsection{Method \code{print()}}{
Prints a formatted representation of the factorial design object, including design matrices and responses.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-.clear"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-.clear}{}}}
\subsection{Method \code{.clear()}}{
Clears the factorial design object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$.clear()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-names"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-names}{}}}
\subsection{Method \code{names()}}{
Get or set the names of the factors in the factorial design.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$names(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Character vector with new names for the factors. If missing, retrieves the current names.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-as.data.frame"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-as.data.frame}{}}}
\subsection{Method \code{as.data.frame()}}{
Converts the factorial design object to a data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$as.data.frame()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-get"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-get}{}}}
\subsection{Method \code{get()}}{
Retrieves elements from the factorial design object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$get(i, j)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{i}}{Row index.}

\item{\code{j}}{Column index.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-lows"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-lows}{}}}
\subsection{Method \code{lows()}}{
Get or set the lower bounds of the factors in the factorial design.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$lows(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Numeric vector with new lower bounds. If missing, retrieves the current lower bounds.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-highs"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-highs}{}}}
\subsection{Method \code{highs()}}{
Get or set the upper bounds of the factors in the factorial design.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$highs(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Numeric vector with new upper bounds. If missing, retrieves the current upper bounds.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-.nfp"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-.nfp}{}}}
\subsection{Method \code{.nfp()}}{
Prints a summary of the factors attributes including their low, high, name, unit, and type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$.nfp()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-identity"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-identity}{}}}
\subsection{Method \code{identity()}}{
Returns the factorial design object itself, used to verify or return the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$identity()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-summary"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-summary}{}}}
\subsection{Method \code{summary()}}{
Summarizes the factorial design object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$summary()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-.response"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-.response}{}}}
\subsection{Method \code{.response()}}{
Get or set the response data in the factorial design object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$.response(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Data frame or numeric vector with new responses. If missing, retrieves the current responses.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-effectPlot"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-effectPlot}{}}}
\subsection{Method \code{effectPlot()}}{
Plots the effects of factors on the response variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$effectPlot(
  factors,
  fun = mean,
  response = NULL,
  lty,
  xlab,
  ylab,
  main,
  ylim
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{factors}}{Factors to be plotted.}

\item{\code{fun}}{Function applied to the response variables (e.g., mean).}

\item{\code{response}}{Optional; specifies which response variables to plot.}

\item{\code{lty}}{Line type for plotting.}

\item{\code{xlab}}{Label for the x-axis.}

\item{\code{ylab}}{Label for the y-axis.}

\item{\code{main}}{Main title for the plot.}

\item{\code{ylim}}{Limits for the y-axis.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-lm"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-lm}{}}}
\subsection{Method \code{lm()}}{
Fits a linear model to the response data in the factorial design object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$lm(formula)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{formula}}{Formula specifying the model to be fitted.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-desires"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-desires}{}}}
\subsection{Method \code{desires()}}{
Get or set the desirability values for the response variables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$desires(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{List of new desirability values. If missing, retrieves the current desirability values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-set.fits"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-set.fits}{}}}
\subsection{Method \code{set.fits()}}{
Set the fits for the response variables in the factorial design object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$set.fits(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New fits.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-types"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-types}{}}}
\subsection{Method \code{types()}}{
Get or set the types of designs used in the factorial design object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$types(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New design types. If missing, retrieves the current types.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-unit"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-unit}{}}}
\subsection{Method \code{unit()}}{
Get or set the units for the factors in the factorial design object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$unit(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New units. If missing, retrieves the current units.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-.star"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-.star}{}}}
\subsection{Method \code{.star()}}{
Get or set the star points in the factorial design object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$.star(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New star points. If missing, retrieves the current star points.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-.blockGen"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-.blockGen}{}}}
\subsection{Method \code{.blockGen()}}{
Get or set the block generators in the factorial design object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$.blockGen(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New block generators. If missing, retrieves the current block generators.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-.block"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-.block}{}}}
\subsection{Method \code{.block()}}{
Get or set the blocks in the factorial design object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$.block(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New blocks. If missing, retrieves the current blocks.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-.centerCube"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-.centerCube}{}}}
\subsection{Method \code{.centerCube()}}{
Get or set the center points in the cube portion of the factorial design.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$.centerCube(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New center points for the cube. If missing, retrieves the current center points.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-.centerStar"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-.centerStar}{}}}
\subsection{Method \code{.centerStar()}}{
Get or set the center points in the star portion of the factorial design.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$.centerStar(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New center points for the star. If missing, retrieves the current center points.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-.generators"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-.generators}{}}}
\subsection{Method \code{.generators()}}{
Get or set the generators for the factorial design.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$.generators(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{New generators. If missing, retrieves the current generators.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-facDesign.c-clone"></a>}}
\if{latex}{\out{\hypertarget{method-facDesign.c-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{facDesign.c$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
