% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/9_extraPlots.R
\name{dotPlot}
\alias{dotPlot}
\title{dotPlot: Function to create a dot plot}
\usage{
dotPlot(
  x,
  group,
  xlim,
  ylim,
  col,
  xlab,
  ylab,
  pch,
  cex,
  breaks,
  stacked = TRUE,
  main,
  showPlot = TRUE
)
}
\arguments{
\item{x}{A numeric vector containing the values to be plotted.}

\item{group}{(Optional) A vector for grouping the values. This determines the grouping of the data points in the dot plot.}

\item{xlim}{A numeric vector of length 2 specifying the limits of the x-axis (lower and upper limits).}

\item{ylim}{A numeric vector of length 2 specifying the limits of the y-axis (lower and upper limits).}

\item{col}{A vector containing numeric values or strings specifying the colors for the different groups in the dot plot.}

\item{xlab}{A title for the x-axis.}

\item{ylab}{A title for the y-axis.}

\item{pch}{A vector of integers specifying the symbols or a single character to be used for plotting points for the different groups in the dot plot.}

\item{cex}{The amount by which points and symbols should be magnified relative to the default.}

\item{breaks}{A numeric vector specifying the breakpoints for binning the values in \code{x}.}

\item{stacked}{A logical value indicating whether the groups should be plotted in a stacked dot plot (default is \code{TRUE}).}

\item{main}{A title for the plot.}

\item{showPlot}{A logical value indicating whether to display the plot. Default is \code{TRUE}.}
}
\value{
A list cointaining:
\itemize{
\item {An invisible matrix containing \code{NA}s and numeric values representing values in a bin. The number of bins is given by the number of columns of the matrix.}
\item {The graphic.}
}
}
\description{
Creates a dot plot. For data in groups, the dot plot can be displayed stacked or in separate regions.
}
\details{
Values in \code{x} are assigned to the bins defined by \code{breaks}. The binning is performed using \code{hist}.
}
\examples{
# Create some data and grouping
set.seed(1)
x <- rnorm(28)
g <- rep(1:2, 14)

# Dot plot with groups and no stacking
dotPlot(x, group = g, stacked = FALSE, pch = c(19, 20), main = "Non stacked dot plot")

# Dot plot with groups and stacking
dotPlot(x, group = g, stacked = TRUE, pch = c(19, 20), main = "Stacked dot plot")
}
