% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSplotDynamicB0.R
\name{SSplotDynamicB0}
\alias{SSplotDynamicB0}
\title{Plot Dynamic B0}
\usage{
SSplotDynamicB0(
  replist,
  ylab = "Spawning biomass (mt)",
  equilibrium = TRUE,
  forecast = FALSE,
  yrs = "all",
  plot = TRUE,
  print = FALSE,
  plotdir = "default",
  verbose = TRUE,
  uncertainty = TRUE,
  legend = TRUE,
  legendlabels = c("equilibrium", "without fishing", "with fishing"),
  legendloc = "bottom",
  col = c("blue", "red"),
  lty = 1,
  lwd = 2,
  add = FALSE,
  pwidth = 6.5,
  pheight = 5,
  punits = "in",
  res = 300,
  ptsize = 10,
  mainTitle = FALSE,
  mar = NULL
)
}
\arguments{
\item{replist}{A list object created by \code{\link{SS_output}()}.}

\item{ylab}{Y-axis label. Default is "Spawning biomass (mt)" which is replaced
by "Spawning output" for models with \code{replist[["SpawnOutputUnits"]] == "numbers"}}

\item{equilibrium}{Show equilibrium in plot? Applies whether "yrs" is specified
or not.}

\item{forecast}{Show forecast years in plot? Only applies if yrs = "all".}

\item{yrs}{Which years to include. Default "all" will show startyr to endyr + 1
modified by the arguments \code{forecast}.}

\item{plot}{Plot to active plot device?}

\item{print}{Print to PNG files?}

\item{plotdir}{Directory where PNG files will be written. By default it will
be the directory where the model was run.}

\item{verbose}{A logical value specifying if output should be printed
to the screen.}

\item{uncertainty}{Show 95\% uncertainty intervals around point estimates?
These intervals will only appear when uncertainty in the dynamic B0
estimates is available via the control file settings for
"read specs for more stddev reporting".}

\item{legend}{Add a legend?}

\item{legendlabels}{Character vector with labels for the unfished
equilibrium point (if \code{equilibrium = TRUE}) and the two lines showing
spawning biomass or output without and with fishing.}

\item{legendloc}{Location of legend. Either a string like "topleft" or a
vector of two numeric values representing the fraction of the maximum in
the x and y dimensions, respectively. See \code{help("legend")} for more info on
the string options.}

\item{col}{Optional vector of colors to be used for the two lines
(single value will apply to both lines).}

\item{lty}{Optional vector of line types to be used for the two lines
(single value will apply to both lines).}

\item{lwd}{Optional vector of line widths to be used for the two lines
(single value will apply to both lines).}

\item{add}{add to existing plot}

\item{pwidth}{Default width of plots printed to files in units of
\code{punits}. The default is \code{pwidth=6.5}.}

\item{pheight}{Height of plots printed to png files in units of \code{punits}.
Default is designed to allow two plots per page, with \code{pheight_tall} used
for plots that work best with a taller format and a single plot per page.}

\item{punits}{Units for \code{pwidth} and \code{pheight}. Can be "px"
(pixels), "in" (inches), "cm" (centimeters), or "mm" (millimeters).
The default is \code{punits="in"}.}

\item{res}{Resolution of plots printed to files.
The default is \code{res = 300}.}

\item{ptsize}{Point size for plotted text in plots printed to files (see
\code{help("png")} in R for details).}

\item{mainTitle}{Logical indicating if a title should be included at the top
(not yet implemented for all plots)}

\item{mar}{Either NULL to allow the default (which depends on whether the main title is included or not) or a numerical vector of the form c(bottom, left, top, right) which gives the number of lines of margin to be specified on the four sides of the plot, which is passed to \code{par()}.}
}
\description{
Plots the spawning output with and without fishing mortality
}
\seealso{
\code{\link[=SSplotTimeseries]{SSplotTimeseries()}}
}
\author{
Ian G. Taylor
}
