% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_subareas_random.R
\name{count_subareas_random}
\alias{count_subareas_random}
\title{Random Subgrid Sampling of a Binary Matrix}
\usage{
count_subareas_random(matrix_data, sub_rows = 3, sub_cols = 3, n_samples = 100)
}
\arguments{
\item{matrix_data}{A binary matrix of 0s and 1s.}

\item{sub_rows}{Number of rows in each subgrid sample.}

\item{sub_cols}{Number of columns in each subgrid sample.}

\item{n_samples}{Number of subgrid samples to draw.}
}
\value{
A list of sampled subgrids. Each element is a list with:
\item{position}{Row and column start position of the sample.}
\item{submatrix}{The sampled subgrid matrix.}
\item{count}{Number of 1s in the sampled submatrix.}
}
\description{
Randomly samples submatrices (quadrats) of specified size from a binary matrix,
and returns the positions, submatrices, and count of 1s in each sampled quadrat.
}
\seealso{
Other Spatial analysis: 
\code{\link{AFSD}()},
\code{\link{BPL}()},
\code{\link{count_subareas}()},
\code{\link{fit_gradients}()},
\code{\link{join_count}()},
\code{\link{oruns_test}()},
\code{\link{oruns_test_boustrophedon}()},
\code{\link{oruns_test_byrowcol}()},
\code{\link{plot_AFSD}()}
}
\concept{Spatial analysis}
