% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/style.R
\name{m_style_line}
\alias{m_style_line}
\title{Specify Styling for Lines}
\usage{
m_style_line(
  colorScheme = "default",
  color = NULL,
  opacity = 1,
  hidden = FALSE
)
}
\arguments{
\item{colorScheme}{Specify scheme to color the atoms by. Default is
"default". Other choies are "Carbon", ssPyMOL", "ssJmol", "Jmol",
"default", "amino",
"shapely", "nucleic", "chain", "chainHetatm", "prop".}

\item{color}{Fixed coloring, overrides \code{colorScheme}.}

\item{opacity}{Opacity, must be the same for all atoms in the model.}

\item{hidden}{Logical, do not show line.}
}
\description{
Styling options for the line representation. Used inside
\code{m_add_style()} and \code{m_set_style()}. Can also be used for styling
when adding individual lines with \code{m_add_line()}.
}
\examples{
r3dmol() \%>\%
  m_add_model(data = pdb_1j72, format = "pdb") \%>\%
  m_set_style(style = m_style_line(color = "blue")) \%>\%
  m_zoom_to()
}
