% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unqualify.R
\name{unqualify_query}
\alias{unqualify_query}
\title{Remove prefixes from column references in a parsed SQL query}
\usage{
unqualify_query(tree, prefixes, except = character(0))
}
\arguments{
\item{tree}{a list returned by \code{\link{parse_query}} containing named
elements representing the clauses of a SQL \code{SELECT} statement}

\item{prefixes}{a character vector containing one or more table names or
table aliases}

\item{except}{a character vector containing column references to leave as is
(optional)}
}
\value{
A list the same as \code{tree} but with all column references in the
  \code{SELECT}, \code{WHERE}, \code{GROUP BY}, \code{HAVING}, and
  \code{ORDER BY} clauses unqualified, except those in \code{except}
}
\description{
Unqualifies column references in the clauses of a parsed SQL
  \code{SELECT} statement that begin with any of the specified prefixes
  followed by a dot
}
\details{
In the returned list, the \code{FROM} clause is unmodified and
  column alias assignments made in the \code{SELECT} clause are unmodified.
}
\examples{
my_query <- "SELECT f.flight,
    manufacturer, p.model
  FROM flights f
    JOIN planes p USING (tailnum);"

unqualify_query(
  parse_query(my_query),
  prefixes = c("p", "f")
)
}
\seealso{
\code{\link{parse_query}}
}
