% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_to_polygon.R
\name{grid_to_polygon}
\alias{grid_to_polygon}
\title{Convert a grid of QuadKeys to square polygons}
\usage{
grid_to_polygon(data)
}
\arguments{
\item{data}{A \code{sf} POINT data.frame with a \code{quadkey} and \code{geometry} column.}
}
\value{
A sf POLYGON data.frame with a quadkey column.
}
\description{
The main argument of this function, the grid of
geographic coordinates (lat/long WG84) represents the upper-left
corner of the QuadKey.
To transform these coordinates into square polygons, the function
supplements the grid by adding a row and column of tiles. These points
introduce QuadKeys located at the border of the area using the internal
function \code{complete_grid_for_polygons()}.
The function builds the polygons using all the points of the grid.
Note that it's possible to associate each QuadKey with its square polygon.
}
\examples{
grid <- create_qk_grid(
  xmin = -59,
  xmax = -57,
  ymin = -35,
  ymax = -34,
  zoom = 11
)

grid_coords <- get_qk_coord(data = grid$data)

polygrid <- grid_to_polygon(grid_coords)
polygrid
}
