% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{subset_input}
\alias{subset_input}
\title{Subset an input object - allele probabilities array or phenotypes matrix or covariates matrix. Kinship has its own subset function}
\usage{
subset_input(input, id2keep)
}
\arguments{
\item{input}{a matrix of either phenotypes or covariates or array of allele probabilities}

\item{id2keep}{a character vector of subject ids to identify those subjects that are shared by all inputs}
}
\value{
an object resulting from subsetting of `input`. Its rows are ordered per `id2keep`
}
\description{
An inputted matrix or 3-dimensional array is first subsetted - by rownames - to remove
those subjects who are not in `id2keep`. After that, the object's rows
are ordered to match the ordering of subject ids in the vector `id2keep`. This
(possibly reordered) object is returned.
}
\examples{
# define s_id
s_id <- paste0("s", 1:10)
# set up input matrix
foo <- matrix(data = rnorm(10 * 3), nrow = 10, ncol = 3)
rownames(foo) <- s_id
subset_input(input = foo, id2keep = s_id)
}
