% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fst_path.R
\name{replace_path}
\alias{replace_path}
\title{Replace the path used in fst_genoprob object}
\usage{
replace_path(object, path)
}
\arguments{
\item{object}{An object of class \code{"fst_genoprob"} as created by \code{\link[=fst_genoprob]{fst_genoprob()}}.}

\item{path}{New path (directory + file stem as a single character string) to be used in the object.}
}
\value{
The input \code{object} with the path replaced.
If any of the expected files don't exist with the new path, warnings are issued.
}
\description{
Replace the path used in an fst_genoprob object.
}
\examples{
library(qtl2)
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
probs <- calc_genoprob(grav2, error_prob=0.002)
dir <- tempdir()
fprobs <- fst_genoprob(probs, "grav2", dir, overwrite=TRUE)

# move the probabilities into a different directory
new_dir <- file.path(tempdir(), "subdir")
if(!dir.exists(new_dir)) dir.create(new_dir)
for(file in fst_files(fprobs)) {
   file.rename(file, file.path(new_dir, basename(file)))
}

# revise the path in fprobs
new_path <- sub(dir, new_dir, fst_path(fprobs), fixed=TRUE)
fprobs <- replace_path(fprobs, new_path)
}
\seealso{
\code{\link[=fst_path]{fst_path()}}, \code{\link[=fst_files]{fst_files()}}
}
