% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop_markers.R
\name{drop_nullmarkers}
\alias{drop_nullmarkers}
\title{Drop markers with no genotype data}
\usage{
drop_nullmarkers(cross, quiet = FALSE)
}
\arguments{
\item{cross}{Object of class \code{"cross2"}. For details, see the
\href{https://kbroman.org/qtl2/assets/vignettes/developer_guide.html}{R/qtl2 developer guide}.}

\item{quiet}{If FALSE, print information about how many markers were dropped.}
}
\value{
The input \code{cross} with the uninformative markers removed.
}
\description{
Drop markers with no genotype data (or no informative genotypes)
}
\details{
We omit any markers that have completely missing data, or
if founder genotypes are present (e.g., for Diversity Outbreds),
the founder genotypes are missing or are all the same.
}
\examples{
grav2 <- read_cross2(system.file("extdata", "grav2.zip", package="qtl2"))
# make a couple of markers missing
grav2$geno[[2]][,c(3,25)] <- 0
grav2_rev <- drop_nullmarkers(grav2)
}
\seealso{
\code{\link[=drop_markers]{drop_markers()}}, \code{\link[=pull_markers]{pull_markers()}}
}
