% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractLT.R
\name{extractLT}
\alias{extractLT}
\alias{extractLTpwr}
\title{Obtain complete set of LT or LD estimates}
\usage{
extractLT(
  obj,
  a = 1:3,
  b = 4:6,
  link = NULL,
  logscale = FALSE,
  p = 0.99,
  eps = 0,
  offset = 0,
  df.t = NULL
)

extractLTpwr(
  obj,
  a = 1:3,
  b = 1:3,
  link = "fpower",
  logscale = FALSE,
  p = 0.99,
  lambda = 0,
  eps = 0.015,
  offset = 0,
  df.t = NULL
)
}
\arguments{
\item{obj}{\code{merMod} object, created using \code{lmer()} or
\code{glmerMod} object, created using \code{glmer()}.}

\item{a}{Subscripts for intercepts.}

\item{b}{Subscripts for corresponding slopes.}

\item{link}{Link function, for use with objects where no
link was specified in the function call, but it is required
to back-transform a transformation that was performed prior
to the function call.  Otherwise leave as \code{link=NULL}, and
the link function will be extracted as \code{family(obj)[['link']]}.
For a folded power function, with \code{extractLTpwr()}, the only
available link is \code{fpower}, and the exponent \code{lambda} must be
specified.}

\item{logscale}{Logical.  Specify \code{TRUE}, if LT values are
to be back-transformed from a logarithmic scale.}

\item{p}{Target response proportion.}

\item{eps}{Replace \code{prob} by \code{prob+eps} before transformation.}

\item{offset}{Use to undo scaling of time or dose variable. This is
passed to the \code{\link{fieller}} function that \code{extractLT}
calls.}

\item{df.t}{Degrees of freedom for a t-distribution approximation
for `t` or `z` statistics.  If NULL, a conservative (low) value will
be used.  For linear (but not generalized linear) models and mixed
models, approximations are implemented in the \pkg{afex} package.
 See \code{vignette('introduction-mixed-models', package="afex")}, page 19.}

\item{lambda}{(\code{extractLTpwr} only) Power for power function.}
}
\value{
Matrix holding LD or LD estimates.
}
\description{
When supplied with a model object that has fitted
dose-response lines for each of several levels of a factor,
\code{extractLT} calls the function \code{fieller} to calculate lethal time
}
\details{
Fixed coefficients from \code{obj} must be for intercepts and
for slopes.  Starting the model formula with \code{0+} will commonly
do what is required. The coefficients \code{fixef(obj)[a]} are assumed
to specify line intercepts, while \code{fixef(obj)[b]} specify the
corresponding slopes.  These replace the arguments \code{nEsts}
(subscripts for intercepts were \code{1:nEsts)} and \code{slopeAdd}
(subscripts for slopes were \code{(nEsts+1):(nEsts+slopeAdd)}).
}
\examples{
pcheck <- suppressWarnings(requireNamespace("glmmTMB", quietly = TRUE))
if(pcheck) pcheck & packageVersion("glmmTMB") >= "1.1.2"
if(pcheck){
form <- cbind(Dead,Live)~0+trtGp/TrtTime+(1|trtGpRep)
HawMed <- droplevels(subset(HawCon, CN=="MedFly"&LifestageTrt!="Egg"))
HawMed <- within(HawMed,
                 {trtGp <- factor(paste0(CN,LifestageTrt, sep=":"))
                 trtGpRep <- paste0(CN,LifestageTrt,":",RepNumber)
                 scTime <- scale(TrtTime) })
HawMedbb.cll <- glmmTMB::glmmTMB(form, dispformula=~trtGp+splines::ns(scTime,2),
                                 family=glmmTMB::betabinomial(link="cloglog"),
                                 data=HawMed)
round(qra::extractLT(p=0.99, obj=HawMedbb.cll, link="cloglog",
               a=1:3, b=4:6, eps=0, df.t=NULL)[,-2], 2)} else
message("Example requires `glmmTMB` version >= 1.1.2: not available")

}
