% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordinal_tmb.R
\name{qbrmO}
\alias{qbrmO}
\title{Quick Bayesian Ordinal Regression Models with Adaptive Centering}
\usage{
qbrmO(
  formula,
  data,
  family = cumulative(),
  prior = NULL,
  verbose = FALSE,
  threshold_method = "quantile",
  control = list(),
  ...
)
}
\arguments{
\item{formula}{Model formula with ordinal response on the left-hand side.}

\item{data}{Data frame containing the variables in the model.}

\item{family}{Ordinal family specification. Currently supports cumulative().}

\item{prior}{Prior specifications using qbrms prior syntax.}

\item{verbose}{Logical; print progress messages during fitting.}

\item{threshold_method}{Method for threshold centering ("quantile" or "cumulative_mean").}

\item{control}{List of control parameters for TMB optimization.}

\item{...}{Additional arguments passed to TMB functions.}
}
\value{
An object of class c("tmb_ordinal_qbrms_fit", "qbrms_fit")
}
\description{
Fits ordinal regression models using Template Model Builder (TMB) with
Laplace approximation and adaptive threshold centering to match brms output.
}
