% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_analysis_tools.R
\name{bayesfactor}
\alias{bayesfactor}
\title{Bayesian Hypothesis Testing (very simple approximations)}
\usage{
bayesfactor(
  object,
  hypothesis,
  prior = NULL,
  null = 0,
  direction = "two-sided",
  rope = NULL,
  nsim = 4000,
  verbose = TRUE
)
}
\arguments{
\item{object}{A \code{qbrms_fit} object.}

\item{hypothesis}{Character string, for example "Intercept > 0",
"b_x = 0", or "b_x > 0.2".}

\item{prior}{Optional prior information (unused here, kept for API compatibility).}

\item{null}{Numeric null value for point tests (default 0).}

\item{direction}{One of "two-sided", "greater", "less" (kept for API compatibility).}

\item{rope}{Optional numeric length-2 vector \code{c(lower, upper)} to
define a ROPE for point tests.}

\item{nsim}{Number of posterior draws to simulate from the fitted summary.}

\item{verbose}{Logical; print progress information.}
}
\value{
An object of class \code{qbrms_bayesfactor}.
}
\description{
Compute a crude Bayes factor for a point, interval, or comparison hypothesis
using approximate posterior draws recovered from a \code{qbrms_fit}.
This is deliberately simple and intended for exploratory use.
}
