% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayesR2.R
\name{bayes_R2}
\alias{bayes_R2}
\title{Bayesian R-squared for qbrms Models}
\usage{
bayes_R2(
  object,
  summary = TRUE,
  robust = FALSE,
  probs = c(0.025, 0.975),
  ndraws = 1000,
  newdata = NULL,
  verbose = TRUE
)
}
\arguments{
\item{object}{A \code{qbrms_fit} object.}

\item{summary}{Logical; if \code{TRUE} (default), return summary statistics.
If \code{FALSE}, return the posterior draws.}

\item{robust}{Logical; if \code{TRUE}, use robust summary statistics.}

\item{probs}{Numeric vector of quantiles for summary (default: c(0.025, 0.975)).}

\item{ndraws}{Number of posterior draws to use (default: 1000).}

\item{newdata}{Optional data frame for predictions. If \code{NULL}, uses
the original data.}

\item{verbose}{Logical; print progress information.}
}
\value{
If \code{summary = TRUE}, a matrix with summary statistics.
If \code{summary = FALSE}, a vector of R-squared values from posterior draws.
}
\description{
Compute Bayesian R-squared values for qbrms regression models following
the method of Gelman et al. (2019). This corrected version properly handles
mixed-effects models to match brms output exactly.
}
\details{
This implementation handles mixed-effects models by:
\enumerate{
\item Using INLA's fitted values that include random effects when available
\item Correctly sampling random effects from their posterior distributions
\item Properly accounting for the variance decomposition in mixed models
}
}
