% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WeightDifference.R
\name{WeightDifference}
\alias{WeightDifference}
\title{Weight Difference}
\usage{
WeightDifference(data, sample = "sample",
  fresh.weight = "fresh.weight")
}
\arguments{
\item{data}{data frame containing at least a numeric column containing the measured weights (g), ordered chronologically by sample. A
column containing the sample IDs is optionally required if several samples were measured.}

\item{sample}{optional name of the column in data containing the sample ID, default: "sample"}

\item{fresh.weight}{optional name of the column in data containing the numeric fresh weight (g) values, default: "fresh.weight"}
}
\value{
the original data frame extended by a numeric column containing the absolute
differences in fresh weight (g) beween the measurements of a sample. The first value of each
sample is NA since weight differences are computed from row i and i-1.
}
\description{
Calculates weight changes between temporally repeated measurements
}
\examples{
# get example data
df <- leaf_drying_data

# extend df by weight difference
df_with_WD <- WeightDifference(df)

}
