% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxSupp.R
\name{as.t_D}
\alias{as.t_D}
\title{Deterministic regressors in \strong{pvars}}
\usage{
as.t_D(x, ...)
}
\arguments{
\item{x}{A list of vectors for \eqn{\tau} to be checked. Since \code{'x'} is
just checked, Section "Value" explains function-input and -output likewise.}

\item{...}{Additional arguments to be passed to or from methods.}
}
\value{
A list of class '\code{t_D}' specifying \eqn{\tau}. 
  Objects of this class can exclusively contain the elements:
\item{t_break}{Vector of integers. The activating periods for 
  trend breaks \eqn{d = [\ldots, 0, 0, 1, 2, 3, \ldots}].}
\item{t_shift}{Vector of integers. The activating periods for 
  shifts in the constant \eqn{d = [\ldots, 0, 0, 1, 1, 1, \ldots}].}
\item{t_impulse}{Vector of integers. The activating periods for 
  single impulses \eqn{d = [\ldots, 0, 0, 1, 0, 0, \ldots}].}
\item{t_blip}{Vector of integers. The activating period for 
  blips \eqn{d = [\ldots, 0, 0, 1, -1, 0, \ldots}].}
\item{n.season}{Integer. The number of seasons.}
}
\description{
Deterministic regressors can be specified via the arguments of
  the \strong{\emph{conventional}} '\code{type}', \strong{\emph{customized}} 
  '\code{D}', and \strong{\emph{period-specific}} '\code{t_D}'. 
  While '\code{type}' is a single character and 
  '\code{D}' a data matrix of dimension \eqn{(n_{\bullet} \times (p+T))}, 
  the specifications for \eqn{\tau} in the list '\code{t_D}' are more complex  
  and therefore preventively checked by \code{\link{as.t_D}}.
}
\section{Reference Time Interval}{

  The complete time series (i.e. including the presample) constitutes 
  the reference time interval. Accordingly, '\code{D}' contains \eqn{p+T} 
  observations, and '\code{t_D}' contains the positions of activating 
  periods \eqn{\tau} in \eqn{1,\ldots,(p+T)}. In a balanced panel 
  \eqn{p_i+T_i = T^*}, the same date implies the same \eqn{\tau} in 
  \eqn{1,\ldots,T^*}, as shown in the example for \code{\link{pcoint.CAIN}}. 
  However, in an unbalanced panel, the same date can imply different 
  \eqn{\tau} across \eqn{i} in accordance with the individual time interval 
  \eqn{1,\ldots,(p_i+T_i)}. Note that across the time series in '\code{L.data}', 
  it is the last observation in each data matrix that refers to the same date.
}

\section{Conventional Type}{
 
  An overview is given here and a detailed explanation in the package vignette. 
\itemize{
\item{\strong{type (VAR)} is specified in VAR models just as in \strong{vars}' \code{\link[vars]{VAR}}, 
      namely by a '\code{const}', a linear '\code{trend}', '\code{both}', or '\code{none}' of those.}
\item{\strong{type_SL} is used in the 'additive' SL procedure for testing the cointegration rank only,
  which removes the mean ('\code{SL_mean}') or mean and linear trend 
  ('\code{SL_trend}') by GLS-detrending.}
\item{\strong{type (VECM)} is used in the 'innovative' Johansen procedure 
  for testing the cointegration rank and estimating the VECM. In accordance 
  with Juselius (2007, Ch.6.3), the available model specifications are:
  '\code{Case1}' for none, 
  '\code{Case2}' for a constant in the cointegration relation,
  '\code{Case3}' for an unrestricted constant, 
  '\code{Case4}' for a  linear trend in the cointegration relation and an unrestricted constant, or 
  '\code{Case5}' for an unrestricted constant and linear trend.}
}
}

\examples{
t_D = list(t_impulse=c(10, 20, 35), t_shift=10)
as.t_D(t_D)

}
\references{
Juselius, K. (2007): 
  \emph{The Cointegrated VAR Model: Methodology and Applications}, 
  Advanced Texts in Econometrics, Oxford University Press, USA, 2nd ed.
}
