% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_receipt.R
\name{check_receipt}
\alias{check_receipt}
\alias{is.acknowledged}
\title{Check whether an emergency priority message was received}
\usage{
check_receipt(receipt, app = get_pushover_app())

is.acknowledged(receipt, app = get_pushover_app())
}
\arguments{
\item{receipt}{receipt ID from sending an emergency message}

\item{app}{application token (see \code{\link[=set_pushover_app]{set_pushover_app()}})}
}
\value{
a list containing the following fields:
\itemize{
\item \code{status}: request status (\code{1} = success)
\item \code{acknowledged}: number indicating whether (\code{1}) or not (\code{0})
notification has been acknowledged
\item \code{acknowledged_at}: Unix timestamp indicating when notification was
acknowledged, or 0
\item \code{acknowledged_by}: key of the user who first acknowledged the
notification, or \code{""}
\item \code{acknowledged_by_device}: name of the device on which the first
user acknowledged the notification
\item \code{last_delivered_at}: Unix timestamp of when the notification was
last acknowledged, or \code{0}
\item \code{expired}: whether (\code{1}) or not (\code{0}) the notification has expired
\item \code{expires_at}: Unix timestamp indicating when the notification will
no longer be retried
\item \code{called_back}: whether (\code{1}) or not (\code{0}) the callback URL has been
visited
\item \code{called_back_at}: Unix timestamp indicating when the callback URL
was visited
\item \code{request}: unique request ID
\item \code{errors}: a list of error messages (only for unsuccessful requests)
\item \code{raw}: the raw \link[httr:response]{httr::response} object
}
}
\description{
\code{check_receipt()} checks the status of an emergency priority message,
receiving information about whether and by whom it was acknowledged,
when the message was last delivered, whether a callback URL was visited,
and more.

\code{is.acknowledged()} returns a logical value indicating whether
or not the emergency message was acknowledged.
}
\examples{
\dontrun{
msg1 <- pushover_emergency(message = "Test emergency message")
check_recepit(receipt = msg1$receipt)
is.acknowledged(receipt = msg1$receipt)
}
}
