% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_substance_groups_uds.R
\docType{data}
\name{meta_substance_groups_uds}
\alias{meta_substance_groups_uds}
\title{Metadata About UDS Groupings}
\format{
A tibble with 13 rows and
4 variables:

\describe{
\item{\strong{Substance}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Alcohol) \cr
    \tab  \cr
   \emph{Description:} \tab substances screened by UDS per study; names drawn from trial case report forms \cr
    \tab  \cr
   \emph{Levels:} \tab Alcohol, Amphetamine, Barbiturate, Benzodiazepine, Buprenorphine, Cannabinoids, Cocaine, Methadone, Methamphetamine, Opiate 2000, Opiate 300, Oxycodone, Propoxyphene \cr
}


}
\item{\strong{CTN-0027}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Alcohol) \cr
    \tab  \cr
   \emph{Description:} \tab Derived label used to group substances of interest, or "NO" if the substance was not screened for in ctn_0027 \cr
    \tab  \cr
   \emph{Levels:} \tab Alcohol, Amphetamine, Benzodiazepine, Cocaine, Methadone, NO, Opioid, THC \cr
}


}
\item{\strong{CTN-0030}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Amphetamine) \cr
    \tab  \cr
   \emph{Description:} \tab Derived label used to group substances of interest, or "NO" if the substance was not screened for in ctn_0030 \cr
    \tab  \cr
   \emph{Levels:} \tab Amphetamine, Benzodiazepine, Buprenorphine, Cocaine, Methadone, NO, Opioid, THC \cr
}


}
\item{\strong{CTN-0051}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = Amphetamine) \cr
    \tab  \cr
   \emph{Description:} \tab Derived label used to group substances of interest, or "NO" if the substance was not screened for in ctn_0051 \cr
    \tab  \cr
   \emph{Levels:} \tab Amphetamine, Barbiturate, Benzodiazepine, Buprenorphine, Cocaine, Methadone, NO, Opioid, THC \cr
}


}
}
}
\usage{
data(meta_substance_groups_uds)
}
\description{
A table of the substances assessed in three clinical trials via
urine drug screen (UDS) and their groupings.
}
\details{
This table indicates which substances were screened in each trial.
The first column (\code{substance}) is drawn from labels which appear in case
report forms for the three clinical trials. The remaining three columns
hold \code{"NO"} if a substance was not screened in that trial, or a grouping
label indicating what type of drug was screened. The ungrouped data can be
found in \link{all_drugs}.

For example, \code{"Opiate 300 ng"} and \code{"Oxycodone"} are assigned to the
grouping label \code{"Opioid"}, and they were assessed in each clinical trial
(so none of the rows show \code{"NO"}). In contrast, while \code{"Opiate 2000 ng"} is
also assigned to the grouping label \code{"Opioid"}, it was neither assessed in
ctn_0027 nor ctn_0030; thus, the grouping label is \code{"NO"} for these trials.
For more details, see the
\href{../doc/harmonization.html#uds}{Harmonization Information} vignette.
}
\keyword{datasets}
