% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/particlefilter.R
\name{obsfun0}
\alias{obsfun0}
\title{default observation noise function}
\usage{
obsfun0(
  so,
  yt,
  xt = NULL,
  inverse = FALSE,
  N = NULL,
  minsd = 0.01,
  time = NULL
)
}
\arguments{
\item{so}{a numeric vector of length one, specifying either log-transformed standard deviation of the observation error as a fraction of the observation,
or two log-transformed parameters of the form sd=exp(B0)+exp(B1)*x.}

\item{yt}{a number, representing a potential observed value of xt}

\item{xt}{a number or numeric vector of "true" (or simulated) abundances at time t, from which the likelihood of yt will be calculated - defaults to NULL for inverse=TRUE}

\item{inverse}{a logical specifying whether inverse (i.e. random number generator) function should be implemented - defaults to FALSE}

\item{N}{number of draws from the random number generator, if inverse=TRUE - defaults to NULL}

\item{minsd}{minimum observation error allowed (e.g. if observation = 0), to prevent log likelihoods of -infinity - defaults to 0.01}

\item{time}{the timestep - defaults to NULL (i.e. not used)}
}
\value{
If inverse=FALSE, returns a list including LL, a number or numeric vector of length xt, with predicted log likelihoods of observation yt,
and wts, a number or vector with weights corresponding to the relative likelihood of each observation (after accounting for variable continuous vs. discrete probability distributions).
If inverse = FALSE, returns N random draws from the observation function.
}
\description{
Two options: If inverse=FALSE, calculates the log probability density of observation yt based on true state xt and observation error.
Otherwise, simulates N random observations of yt.
Observation error follows a Gaussian distribution truncated at zero, using a Tobit distribution.
Note that probability density is calculated based on a Tobit distribution, with lower boundary zero.
}
\keyword{error}
\keyword{observation}
