% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetVaporPressureDeficit}
\alias{GetVaporPressureDeficit}
\title{Return Vapor pressure deficit given dry-bulb temperature, humidity ratio, and pressure.}
\usage{
GetVaporPressureDeficit(TDryBulb, HumRatio, Pressure)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{HumRatio}{A numeric vector of humidity ratio in lb_H2O lb_Air-1 [IP] or kg_H2O kg_Air-1 [SI]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of vapor pressure deficit in Psi [IP] or Pa [SI]
}
\description{
Return Vapor pressure deficit given dry-bulb temperature, humidity ratio, and pressure.
}
\examples{
SetUnitSystem("IP")
GetVaporPressureDeficit(80:100, 0.01, 14.175)

SetUnitSystem("SI")
GetVaporPressureDeficit(20:30, 0.01, 95461.0)

}
\references{
Oke (1987) eqn 2.13a
}
