% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_survrmst.R
\name{rwe_rmst}
\alias{rwe_rmst}
\title{RMST Estimation}
\usage{
rwe_rmst(
  dta_cur,
  dta_ext,
  dta_cur_trt,
  n_borrow = 0,
  pred_tps = NULL,
  stderr_method = "naive"
)
}
\arguments{
\item{dta_cur}{Matrix of time and event from a PS stratum in the current
study (control arm only)}

\item{dta_ext}{Matrix of time and event from a PS stratum in the external
data source (control arm only)}

\item{dta_cur_trt}{Matrix of time and event from a PS stratum in current
study (treatment arm only)}

\item{n_borrow}{Number of subjects to be borrowed}

\item{pred_tps}{All time points of events (unique and sorted)}

\item{stderr_method}{Method for computing StdErr (available for naive only)}
}
\value{
Estimation of RMST estimates at time \code{pred_tps}
}
\description{
Estimate RMST estimates for a single PS
stratum
}
