% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\name{check_consistent_pfs}
\alias{check_consistent_pfs}
\title{Check consistency of PFS definition
Check that PFS is defined consistently with TTP and OS in a dataset. This convenience function compares \code{pfs.durn} with the lower of \code{ttp.durn} and \code{os.durn}, and checks that the event field \code{pfs.flag} is consistent with \code{ttp.flag} and \code{os.flag} (is 1 when either \code{ttp.flag} or \code{os.flag} is one).}
\usage{
check_consistent_pfs(ds)
}
\arguments{
\item{ds}{Tibble of complete patient-level dataset
\itemize{
\item \code{ttp.durn}, \code{pfs.durn}, and \code{os.durn} are the durations of TTP (time to progression), PFS (progression-free survival), and OS (overall survival).
\item \code{ttp.flag}, \code{pfs.flag}, and \code{os.flag}, and \code{pps.flag} are event flag indicators for TTP, PFS, and OS respectively (1=event, 0=censoring).
}}
}
\value{
List containing:
\itemize{
\item \code{durn}: Logical vector comparing expected and actual PFS durations
\item \code{flag}: Logical vector comparing expected and actual PFS event flags
\item \code{all}: Single logical value of TRUE if all durations and flags match as expected, FALSE otherwise
}
}
\description{
Check consistency of PFS definition
Check that PFS is defined consistently with TTP and OS in a dataset. This convenience function compares \code{pfs.durn} with the lower of \code{ttp.durn} and \code{os.durn}, and checks that the event field \code{pfs.flag} is consistent with \code{ttp.flag} and \code{os.flag} (is 1 when either \code{ttp.flag} or \code{os.flag} is one).
}
\examples{
ponc <- create_dummydata("pharmaonc")
check_consistent_pfs(ponc)
}
