% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kepner_robinson.R
\name{kepner_robinson_test_internal}
\alias{kepner_robinson_test_internal}
\title{Kepner-Robinson Test}
\usage{
kepner_robinson_test_internal(
  data,
  time,
  subject,
  distribution,
  na.rm,
  formula = NULL,
  ...
)
}
\arguments{
\item{data}{numeric vector containing the data}

\item{time}{factor vector containing time points}

\item{subject}{factor vector containing subjects}

\item{distribution}{specified distribution, either Chisq or F}

\item{na.rm}{a logical value indicating if NA values should be removed}

\item{formula}{formula object}

\item{...}{further arguments are ignored}
}
\value{
Returns a data.frame with the results
}
\description{
This function calculates the Kepner-Robinsin test under the null hypothesis H0F: F_1 = ... F_k.
}
\examples{
# create some artificial data with 20 subjects measured at two time points
data <- rnorm(40)
time <- rep(c(1,2),20)
subject <- gl(20,2)
df <- data.frame(data=data,time=time,subject=subject)

kepner_robinson_test(data,time,subject)
kepner_robinson_test(data~time,data=df,subject="subject")
}
\references{
Kepner, J. L., & Robinson, D. H. (1988). Nonparametric methods for detecting treatment effects in repeated-measures designs. Journal of the American Statistical Association, 83(402), 456-461.
}
\keyword{internal}
