% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composite.R
\name{mahalanobisComposite}
\alias{mahalanobisComposite}
\title{Score Data Using the Mahalanobis Distance}
\usage{
mahalanobisComposite(object, ncomponents, pca)
}
\arguments{
\item{object}{An object of class \code{CompositeReady}}

\item{ncomponents}{the number of components to use from the
principal component analysis. If missing, defaults to the
number of columns in the data.}

\item{pca}{An optional PCA object from princomp to use.
If not passed, will be calculated from the data.}
}
\value{
An S4 object of class \code{MahalanobisScores}.
}
\description{
Create a composite using the Mahalanobis Distance
}
\examples{
# this example creates distances for the built in mtcars data
# see ?mtcars for more details
# The distances are calculated from the "best" in the dataset
# First we create an appropriate CompositeData class object
# higher mpg & hp are better and lower wt & qsec are better
d <- CompositeData(mtcars[, c("mpg", "hp", "wt", "qsec")],
  thresholds = list(one = with(mtcars, c(
    mpg = max(mpg),
    hp = max(hp),
    wt = min(wt),
    qsec = min(qsec)))
  ),
  higherisbetter = c(TRUE, TRUE, FALSE, FALSE))

# create the distance scores
# and the composite
# covariance matrix will be calculated from the data
# and data will be standardized to unit variance by default
dres <- prepareComposite(d)

# see a density plot of the distance scores
dres@distanceDensity
# regular summary of distance scores
summary(dres@distances)

# examine covariance matrix
round(dres@covmat,2)

# now we can create the composite based on mahalanobis distances
# from our defined thresholds
mcomp <- mahalanobisComposite(dres, 1)

# view a histogram of the composite scores
mcomp@scoreHistogram

# summarize the composite scores
summary(mcomp@scores)

# check the screeplot and loadings
mcomp@screePlot
mcomp@loadingGraph
# examine the loadings as a table
mcomp@loadingTable

# one component is adequate to explain these data
# to be safe can pick first two and re-run model

# use only first two components
mcomp2 <- mahalanobisComposite(dres, ncomponents = 2)

# view a histogram of the updated composite scores
mcomp2@scoreHistogram

# summarize the composite scores
summary(mcomp2@scores)

# compare using all versus two components
plot(mcomp@scores, mcomp2@scores)

# cleanup
rm(d, dres, mcomp, mcomp2)
}
\seealso{
Other composite: 
\code{\link{factorComposite}()},
\code{\link{sumComposite}()}
}
\concept{composite}
