% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis_class.R
\docType{class}
\name{Analysis-class}
\alias{Analysis-class}
\alias{.analysis_obj}
\title{\code{Analysis} Class}
\description{
A class for defining Analysis details. Objects of class
\code{Analysis} should not be created directly but by the constructor
\code{create_analysis_obj()}.
}
\section{Slots}{

\describe{
\item{\code{data_matrix}}{matrix. The data matrix, including all covariates to be
adjusted for, all relevant outcome variables, and treatment arm and external
control arm flags.}

\item{\code{covariates}}{\code{Covariate}. Object of class \code{Covariate} as output by
the function \code{covariate_details()}.}

\item{\code{outcome}}{\code{Outcome}. Object of class \code{Outcome} as output by
\code{outcome_surv_exponential()}, \code{outcome_surv_weibull_ph()}, or \code{outcome_bin_logistic()}.}

\item{\code{borrowing}}{\code{Borrowing}. Object of class \code{Borrowing} as output by
\code{borrowing_full()}, \code{borrowing_none()}, or \code{borrowing_hierarchical_commensurate()}.}

\item{\code{treatment}}{\code{Treatment}. Object of class \code{Treatment} as output by
\code{treatment_details()}.}

\item{\code{model_string}}{character. The string that contains the full
Stan model code to be compiled.}

\item{\code{model}}{\code{CmdStanModel}. The compiled Stan model as output by \code{cmdstanr::cmdstan_model()}}

\item{\code{ready_to_sample}}{logical. Is the object ready to sample?}
}}

